* hazrate.prg
* v1.1
*
* Exports SSUR source data and inflow and outflow rates
*
calendar 1949 1 12
allocate 2015:12

declare integer FIRSTOBS LASTOBS

open data input.csv
data(format=cdf, org=col) / E U U_S
close data
print(picture="*.") / E U U_S

** locate last observation for UR
inquire(series=U) FIRSTOBS LASTOBS

****************************************
*** COMPUTE HAZARD RATES FROM STOCKS ***
****************************************
* adjust for redesign
set orig_U_s = U_s
set U_s * 1994:1 = orig_U_s
set U_s 1994:2 * = 1.1549*orig_U_s
*
set bigF = 1 - ((U{-1} - U_s{-1})/U)
set f = -log(1-bigF)
* set up s series
set s = %na
* iterate
do i = FIRSTOBS,LASTOBS-1
  compute Ei = E(i)
  compute Ui = U(i)
  compute U1i = U(i+1)
  compute fi = f(i)
  nonlin x
  * guess average s
  compute xs = 0.0345
  * transform xs in [0,1] to x in [-inf,inf]
  compute x = log(xs/(1-xs))
  compute value = 0.0
  find(method=genetic,iterations=100,subiterations=100000,cvcrit=0.0001,noprint) root value
    * x in [-inf,inf]; xs in [0,1]
    compute xs = exp(x)/(1+exp(x))
    compute value = U1i - (Ui+Ei)*xs*(1-exp(-fi-xs))/(fi+xs) - Ui*exp(-fi-xs)
  end find
  set s i i = xs
end do
*
print(picture="#.#####") / s f

** STORE SERIES TO CSV FILE
open(noappend) copy output.csv
copy(format=cdf,dates,org=columns) / s f
close copy
